<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mobile extends CI_Controller {
    public function __construct() {
		header('Access-Control-Allow-Origin: *');
	    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
	    header("Access-Control-Allow-Methods: GET, POST");
	    parent::__construct();
	}
	public function periodCycle(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{

			$periodArr = ['04.09.2022','29.09.2022','23.10.2022','18.11.2022','12.12.2022','09.01.2023','04.02.2023','02.03.2023','28.03.2023','24.04.2023','19.05.2023','14.06.2023','11.07.2023','05.08.2023','01.09.2023','26.09.2023','21.10.2023','15.11.2023','09.12.2023',];
			$totalDays = 0;
			for ($i=0; $i < (count($periodArr)-1); $i++) {
				
				$date1 = strtotime($periodArr[$i]);
			    $date2 = strtotime($periodArr[$i+1]);

			    $differenceInSeconds = $date2 - $date1;

			    // Convert the difference to days
			    $differenceInDays = round($differenceInSeconds / (60 * 60 * 24));

			    if($i <= 17 && $i >= 11){
			    	$totalDays += $differenceInDays;
			    }
				echo $i."Date-".date('Y-m-d', ($date1))." To Date-".date('Y-m-d', ($date2))." Cycle in Days -".$differenceInDays;
				echo "<br>";

			}
			$avgDays = round($totalDays / 7);
			echo "Avg cycle: ".$avgDays."<br>";
			$startDate = "";
			$lastDate = '';
			for ($j=0; $j < 6  ; $j++) { 
				if($j==0){
					echo "- Period Predict -<br>";
					$startDate = $periodArr[count($periodArr)-1];
					$lastDate = date('Y-m-d', strtotime('+'.$avgDays.' day', strtotime($startDate)));
				}else{
					$startDate = $lastDate;
					$lastDate = date('Y-m-d', strtotime('+'.$avgDays.' day', strtotime($startDate)));
				}

				echo  $j."Date-".$startDate." To Date-".$lastDate." Cycle in Days -".$avgDays;
				echo "<br>";

			}
			// $lastDayOfMonth = date('Y-m-d'); 
			// $firstDayOfMonth = date('Y-m-d', strtotime('-29 day', strtotime($lastDayOfMonth)));
			
			// '03.01.2024','28.01.2024','22.02.2024','18.03.2024','12.04.2024','07.05.2024'
			
			// echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function periodCalculate(){
	    $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
		    $startDateOfPeriodCycle = $this->input->post('startDateOfPeriodCycle');		    
		    $duration = $this->input->post('duration');
		   	if(!$duration){
		   		$duration = 28;
		   	}
		   	$endDateDuration = $duration - 14;
		   	$endDateOfPeriodCycle = (date('Y-m-d', strtotime('+'.($duration).' day', strtotime($startDateOfPeriodCycle))));		   	
		    $arrayInsert = array(
		        'userId'=>2,
		        'startDate'=>$startDateOfPeriodCycle,
		        'endDate'=>$endDateOfPeriodCycle,
		        'duration'=>$duration,
		        'periodStartDate'=>$startDateOfPeriodCycle,
		        'periodEndDate'=>(date('Y-m-d', strtotime('+'.($duration - 14).' day', strtotime($startDateOfPeriodCycle))))
		        );
		    $result = $this->db->insert('h_period_record',$arrayInsert);


		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}

	public function periodPredictCalculate(){
	    $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
			$previousPeriod = $this->input->post('previousPeriod');
			$userId = $this->input->post('userId');
			$uniqueId = $this->input->post('uniqueId');
			if(!$uniqueId){
			    $uniqueId = uniqid();
			}
			$this->db->where('userId',$userId)->delete('h_period_record');
			$previousPeriods = json_decode($previousPeriod);
			
			foreach ($previousPeriods as $pp) {
				$startDateOfPeriodCycle = (date('Y-m-d',strtotime($pp->startDateOfPeriodCycle)));
				$duration = ($pp->duration)?($pp->duration):28;
				$endDateDuration = $duration - 14;
			    	$endDateOfPeriodCycle = (date('Y-m-d', strtotime('+'.($duration).' day', strtotime($startDateOfPeriodCycle))));		   	
			    $arrayInsert = array(
			        'userId'=>$userId,
			        'uniqueId'=>$uniqueId,
			        'startDate'=>$startDateOfPeriodCycle,
			        'endDate'=>$endDateOfPeriodCycle,
			        'duration'=>$duration,
			        'periodStartDate'=>$startDateOfPeriodCycle,
			        'periodEndDate'=>(date('Y-m-d', strtotime('+'.($duration - 15).' day', strtotime($startDateOfPeriodCycle)))),
			        'dataType'=>'previousData'
			        );
			    $result = $this->db->insert('h_period_record',$arrayInsert);
			}
			$allPreviousData =  $this->db->where('userId',$userId)->where('uniqueId',$uniqueId)->where('dataType','previousData')->order_by('startDate','DESC')->get('h_period_record')->result();
			$newi = 0;
			$loopFirstDate = "";
			$loopSecondDate = "";
			foreach($allPreviousData as $apd){
			    if($newi){
			       $loopSecondDate = $apd->startDate;
			       $differenceInSeconds = strtotime($loopFirstDate) - strtotime($loopSecondDate);
			       $differenceInDays = round($differenceInSeconds / (60 * 60 * 24));
			       $this->db->where('id',$apd->id)->update('h_period_record',array('duration'=>$differenceInDays));
			        
			    }
			    $loopFirstDate = $apd->startDate;
			    $newi++;
			}
			
			
			$periodDuration = $this->db->where('userId',$userId)->where('uniqueId',$uniqueId)->order_by('startDate','DESC')->limit(3)->get('h_period_record');
			$numberOfRows = $periodDuration->num_rows();
			$sumOfPeriodDuration = 0;
			foreach ($periodDuration->result() as $apd) {
				$sumOfPeriodDuration += $apd->duration;
			}
			$avgDays =round($sumOfPeriodDuration/$numberOfRows);
			$startDate = $this->db->where('userId',$userId)->where('uniqueId',$uniqueId)->order_by('startDate','DESC')->get('h_period_record')->row()->endDate;
			$lastDate = '';
			for ($j=0; $j < 6  ; $j++) { 
				if($j==0){
					$lastDate = date('Y-m-d', strtotime('+'.$avgDays.' day', strtotime($startDate)));
				}else{
					$startDate = $lastDate;
					$lastDate = date('Y-m-d', strtotime('+'.$avgDays.' day', strtotime($startDate)));
				}
			    $arrayInsert = array(
			        'userId'=>$userId,
			        'uniqueId'=>$uniqueId,
			        'startDate'=>$startDate,
			        'endDate'=>$lastDate,
			        'duration'=>$avgDays,
			        'periodStartDate'=>$startDate,
			        'periodEndDate'=>(date('Y-m-d', strtotime('+'.($avgDays - 15).' day', strtotime($startDate)))),
			        'dataType'=>'predictData'
			        );
			    $result = $this->db->insert('h_period_record',$arrayInsert);
			}
			$data = $this->db->select('userId,periodStartDate,periodEndDate,dataType')->where('userId',$userId)->where('uniqueId',$uniqueId)->order_by('startDate','DESC')->get('h_period_record')->result();
			if($data){
				$response['status'] = 1;
				$response['message'] = "Data Inserted Successfully";
				$response['result'] = $data;
				$response['uniqueId'] = $uniqueId;
			}else{
				$response['message'] = "No Data Inserted";
			}
        echo json_encode($response); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function getPriodPredictData(){
	    $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
		    $uniqueId = $this->input->post('uniqueId');
		    $userId = $this->input->post('userId');
		    if(!$uniqueId){$response['message']="Please insert a unique Id";echo json_encode($response); die();}
		    if(!$userId){$response['message']="Please insert a user Id";echo json_encode($response); die();}
		    $data = $this->db->select('userId,periodStartDate,periodEndDate,dataType')->where('userId',$userId)->where('uniqueId',$uniqueId)->order_by('startDate','DESC')->get('h_period_record')->result();
		    if($data){
		    	$response['status'] = 1;
		    	$response['message'] = "Data Fetched Successfully";
		    	$response['result'] = $data;
		    }else{
		    	$response['message'] = "unable to fetched Data";
		    }
		    echo json_encode($response); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function login(){
	    $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
		    $deviceToken = $this->input->post('deviceToken');
		    if(!$deviceToken){$response['message']="Please insert a device token";echo json_encode($response); die();}
		    $checkUser = $this->db->where('deviceToken',$deviceToken)->get('h_users')->row();
		    if(!$checkUser){
		    	$result = $this->db->insert('h_users',array('deviceToken'=>$deviceToken));
		    	$checkUser = $this->db->where('deviceToken',$deviceToken)->get('h_users')->row();
		    }
		    if($checkUser){
		    	$response['status'] = 1;
		    	$response['message'] = "Log in Successfully";
		    	$response['result'] = $checkUser;
		    }else{
		    	$response['message'] = "unable to log in";
		    }
		    echo json_encode($response); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}

	public function addUser(){
	    $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
		    $name = $this->input->post('name');
		    $dob = $this->input->post('dob');
		    $cycle = $this->input->post('cycle');
		    $lastPeriod = $this->input->post('lastPeriod');
		    $weddingDate = $this->input->post('weddingDate');
		    $together = $this->input->post('together');
		    $eventNotification = $this->input->post('eventNotification');
		    $periodNotification = $this->input->post('periodNotification');
		    $durationPeriod = $this->input->post('durationPeriod');
		    $userId = $this->input->post('userId');
		    $profileImage = $this->input->post('profileImage');
		    $uniqueId = $this->input->post('uniqueId');
		    
		    if(!$userId){$response['message']="Please insert a userId";echo json_encode($response); die();}
		    if(!$uniqueId){$response['message']="Please insert a uniqueId";echo json_encode($response); die();}
		    if(!$name){$response['message']="Please insert a name";echo json_encode($response); die();}
		    if(!$dob){$response['message']="Please insert a date of birth";echo json_encode($response); die();}
			if(!$cycle){$response['message']="Please insert a period cycle";echo json_encode($response); die();}
			if(!$lastPeriod){$response['message']="Please insert a last period started";echo json_encode($response); die();}
			
			
			if(!$eventNotification){$response['message']="Please insert a Event notification";echo json_encode($response); die();}
			if(!$periodNotification){$response['message']="Please insert a period notification ";echo json_encode($response); die();}
			if(!$durationPeriod){$response['message']="Please insert a duration of her period";echo json_encode($response); die();}
			if(!$profileImage){$response['message']="Please insert a profile image";echo json_encode($response); die();}
			

			$dataInsert = array(
				'name' => $name,
				'dob' => $dob,
				'cycle' => $cycle,
				'lastPeriod' => $lastPeriod,
				'weddingDate' => $weddingDate,
				'together' => $together,
				'eventNotification' => $eventNotification,
				'periodNotification' => $periodNotification,
				'durationPeriod' => $durationPeriod,
				'userId' => $userId,
				'uniqueId'=>$uniqueId,
				'profileImage'=>$profileImage,
			);
			$result = $this->db->insert('h_profile',$dataInsert);
		    $profile = $this->db->where('userId',$userId)->get('h_profile')->result();
		    
		    if($result){
		    	$response['status'] = 1;
		    	$response['message'] = "User profile added Successfully";
		    	$response['result'] = $profile;
		    }else{
		    	$response['message'] = "unable to add  user profiles";
		    }
		    echo json_encode($response); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	    public function editProfile(){
        $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);      
        try{
            $name = $this->input->post('name');
            $dob = $this->input->post('dob');
            $cycle = $this->input->post('cycle');
            $lastPeriod = $this->input->post('lastPeriod');
            $weddingDate = $this->input->post('weddingDate');
            $together = $this->input->post('together');
            $eventNotification = $this->input->post('eventNotification');
            $periodNotification = $this->input->post('periodNotification');
            $durationPeriod = $this->input->post('durationPeriod');
            $userId = $this->input->post('userId');
            $profileImage = $this->input->post('profileImage');
            $uniqueId = $this->input->post('uniqueId');
            
            if(!$userId){$response['message']="Please insert a userId";echo json_encode($response); die();}
            if(!$uniqueId){$response['message']="Please insert a uniqueId";echo json_encode($response); die();}
            if(!$name){$response['message']="Please insert a name";echo json_encode($response); die();}
            if(!$dob){$response['message']="Please insert a date of birth";echo json_encode($response); die();}
            if(!$cycle){$response['message']="Please insert a period cycle";echo json_encode($response); die();}
            if(!$lastPeriod){$response['message']="Please insert a last period started";echo json_encode($response); die();}
            
            
            if(!$eventNotification){$response['message']="Please insert a Event notification";echo json_encode($response); die();}
            if(!$periodNotification){$response['message']="Please insert a period notification ";echo json_encode($response); die();}
            if(!$durationPeriod){$response['message']="Please insert a duration of her period";echo json_encode($response); die();}
            if(!$profileImage){$response['message']="Please insert a profile image";echo json_encode($response); die();}
            

            $dataInsert = array(
                'name' => $name,
                'dob' => $dob,
                'cycle' => $cycle,
                'lastPeriod' => $lastPeriod,
                'weddingDate' => $weddingDate,
                'together' => $together,
                'eventNotification' => $eventNotification,
                'periodNotification' => $periodNotification,
                'durationPeriod' => $durationPeriod,
                'userId' => $userId,
                'uniqueId'=>$uniqueId,
                'profileImage'=>$profileImage,
            );
            $result = $this->db->where('uniqueId',$uniqueId)->update('h_profile',$dataInsert);
            $profile = $this->db->where('uniqueId',$uniqueId)->get('h_profile')->result();
            
            if($result){
                $response['status'] = 1;
                $response['message'] = "User profile added Successfully";
                $response['result'] = $profile;
            }else{
                $response['message'] = "unable to add  user profiles";
            }
            echo json_encode($response); die();
        }catch (Exception $e) {
            echo json_encode($response); die();
        }
    }
    public function deleteProfile(){
        $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);      
        try{
            $uniqueId = $this->input->post('uniqueId');
            if(!$uniqueId){$response['message']="Please insert a uniqueId";echo json_encode($response); die();}
            
            $result = $this->db->where('uniqueId',$uniqueId)->delete('h_profile');            
            if($result){
                $data = $this->db->where('uniqueId',$uniqueId)->get('h_profile')->result();
                $response['status'] = 1;
                $response['message'] = "Observation Deleted Successfully";
                $response['result'] = $data;
            }else{
                $response['message'] = "unable to delete data";
            }
            echo json_encode($response); die();
        }catch (Exception $e) {
            echo json_encode($response); die();
        }
    }
	public function getAllProfile(){
        $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>[]);      
        try{
            $userId = $this->input->post('userId');
            if(!$userId){$response['message']="Please insert a userId";echo json_encode($response); die();}
            $result = $this->db->where('userId',$userId)->get('h_profile')->result();            
            if($result){
                $response['status'] = 1;
                $response['message'] = "Get profile list";
                $response['result'] = $result;
            }else{
                $response['message'] = "unable to get profiles list";
            }
            echo json_encode($response); die();
        }catch (Exception $e) {
            echo json_encode($response); die();
        }
    }
    public function getProfileData(){
        $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);      
        try{
            $uniqueId = $this->input->post('uniqueId');
            if(!$uniqueId){$response['message']="Please insert a uniqueId";echo json_encode($response); die();}
            $result = $this->db->where('uniqueId',$uniqueId)->get('h_profile')->row();            
            if($result){
                $response['status'] = 1;
                $response['message'] = "Get profile Data";
                $response['result'] = $result;
            }else{
                $response['message'] = "unable to get profiles data";
            }
            echo json_encode($response); die();
        }catch (Exception $e) {
            echo json_encode($response); die();
        }
    }
    public function addObservation(){
        $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);      
        try{
            $uniqueId = $this->input->post('uniqueId');
            $text = $this->input->post('text');
            $date = $this->input->post('date');
            if(!$uniqueId){$response['message']="Please insert a uniqueId";echo json_encode($response); die();}
            if(!$text){$response['message']="Please insert a text";echo json_encode($response); die();}
            if(!$date){$response['message']="Please insert a date";echo json_encode($response); die();}

            $result = $this->db->insert('h_observation',array('uniqueId'=>$uniqueId,'text'=>$text,'date'=>$date));            
            if($result){
                $data = $this->db->where('uniqueId',$uniqueId)->get('h_observation')->result();
                $response['status'] = 1;
                $response['message'] = "Observation Inserted Successfully";
                $response['result'] = $data;
            }else{
                $response['message'] = "unable to insert data";
            }
            echo json_encode($response); die();
        }catch (Exception $e) {
            echo json_encode($response); die();
        }
    }
    public function getObservation(){
        $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>[]);      
        try{
            $uniqueId = $this->input->post('uniqueId');
            if(!$uniqueId){$response['message']="Please insert a uniqueId";echo json_encode($response); die();}
            $result =$this->db->where('uniqueId',$uniqueId)->get('h_observation')->result();
            
            if($result){
                $response['status'] = 1;
                $response['message'] = "Observation list fetched Successfully";
                $response['result'] = $result;
            }else{
                $response['message'] = "unable to fetch data";
            }
            echo json_encode($response); die();
        }catch (Exception $e) {
            echo json_encode($response); die();
        }
    }
    public function editObservation(){
        $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);      
        try{
            $id = $this->input->post('id');
            $uniqueId = $this->input->post('uniqueId');
            $text = $this->input->post('text');
            $date = $this->input->post('date');
            if(!$uniqueId){$response['message']="Please insert a uniqueId";echo json_encode($response); die();}
            if(!$id){$response['message']="Please insert a id";echo json_encode($response); die();}

            if(!$text){$response['message']="Please insert a text";echo json_encode($response); die();}
            if(!$date){$response['message']="Please insert a date";echo json_encode($response); die();}
            $result = $this->db->where('id',$id)->update('h_observation',array('text'=>$text,'date'=>$date));            
            if($result){
                $data = $this->db->where('uniqueId',$uniqueId)->get('h_observation')->result();
                $response['status'] = 1;
                $response['message'] = "Observation Updated Successfully";
                $response['result'] = $data;
            }else{
                $response['message'] = "unable to update data";
            }
            echo json_encode($response); die();
        }catch (Exception $e) {
            echo json_encode($response); die();
        }
    }
    public function deleteObservation(){
        $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);      
        try{
            $id = $this->input->post('id');
            $uniqueId = $this->input->post('uniqueId');
            if(!$uniqueId){$response['message']="Please insert a uniqueId";echo json_encode($response); die();}
            if(!$id){$response['message']="Please insert a id";echo json_encode($response); die();}
            $result = $this->db->where('id',$id)->delete('h_observation');            
            if($result){
                $data = $this->db->where('uniqueId',$uniqueId)->get('h_observation')->result();
                $response['status'] = 1;
                $response['message'] = "Observation Deleted Successfully";
                $response['result'] = $data;
            }else{
                $response['message'] = "unable to delete data";
            }
            echo json_encode($response); die();
        }catch (Exception $e) {
            echo json_encode($response); die();
        }
    }
    public function addEvent(){
        $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);      
        try{
            $uniqueId = $this->input->post('uniqueId');
            $detail = $this->input->post('detail');
            $date = $this->input->post('date');
            $repeat = $this->input->post('repeat');
            $notification = $this->input->post('notification');
            if(!$uniqueId){$response['message']="Please insert a uniqueId";echo json_encode($response); die();}
            if(!$detail){$response['message']="Please insert a detail";echo json_encode($response); die();}
            if(!$date){$response['message']="Please insert a date";echo json_encode($response); die();}
            if(!$repeat){$response['message']="Please insert a repeat";echo json_encode($response); die();}
            if(!$notification){$response['message']="Please insert a notification";echo json_encode($response); die();}

            $result = $this->db->insert('h_event',array('uniqueId'=>$uniqueId,'detail'=>$detail,'date'=>$date,'repeat'=>$repeat,'notification'=>$notification));            
            if($result){
                $data = $this->db->where('uniqueId',$uniqueId)->get('h_event')->result();
                $response['status'] = 1;
                $response['message'] = "Event Inserted Successfully";
                $response['result'] = $data;
            }else{
                $response['message'] = "unable to insert data";
            }
            echo json_encode($response); die();
        }catch (Exception $e) {
            echo json_encode($response); die();
        }
    }
    public function getEvent(){
        $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>[]);      
        try{
            $uniqueId = $this->input->post('uniqueId');
            if(!$uniqueId){$response['message']="Please insert a uniqueId";echo json_encode($response); die();}
            $result =$this->db->where('uniqueId',$uniqueId)->get('h_event')->result();
            
            if($result){
                $response['status'] = 1;
                $response['message'] = "Event list fetched Successfully";
                $response['result'] = $result;
            }else{
                $response['message'] = "unable to fetch data";
            }
            echo json_encode($response); die();
        }catch (Exception $e) {
            echo json_encode($response); die();
        }
    }
    public function editEvent(){
        $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);      
        try{
            $id = $this->input->post('id');
            $uniqueId = $this->input->post('uniqueId');
            $detail = $this->input->post('detail');
            $date = $this->input->post('date');
            $repeat = $this->input->post('repeat');
            $notification = $this->input->post('notification');
            if(!$uniqueId){$response['message']="Please insert a uniqueId";echo json_encode($response); die();}
            if(!$detail){$response['message']="Please insert a detail";echo json_encode($response); die();}
            if(!$date){$response['message']="Please insert a date";echo json_encode($response); die();}
            if(!$repeat){$response['message']="Please insert a repeat";echo json_encode($response); die();}
            if(!$notification){$response['message']="Please insert a notification";echo json_encode($response); die();}
            if(!$id){$response['message']="Please insert a id";echo json_encode($response); die();}

            $result = $this->db->where('id',$id)->update('h_event',array('uniqueId'=>$uniqueId,'detail'=>$detail,'date'=>$date,'repeat'=>$repeat,'notification'=>$notification));            
            if($result){
                $data = $this->db->where('uniqueId',$uniqueId)->get('h_event')->result();
                $response['status'] = 1;
                $response['message'] = "Event Updated Successfully";
                $response['result'] = $data;
            }else{
                $response['message'] = "unable to update data";
            }
            echo json_encode($response); die();
        }catch (Exception $e) {
            echo json_encode($response); die();
        }
    }
    public function deleteEvent(){
        $response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);      
        try{
            $id = $this->input->post('id');
            $uniqueId = $this->input->post('uniqueId');
            if(!$uniqueId){$response['message']="Please insert a uniqueId";echo json_encode($response); die();}
            if(!$id){$response['message']="Please insert a id";echo json_encode($response); die();}
            $result = $this->db->where('id',$id)->delete('h_event');            
            if($result){
                $data = $this->db->where('uniqueId',$uniqueId)->get('h_event')->result();
                $response['status'] = 1;
                $response['message'] = "Event Deleted Successfully";
                $response['result'] = $data;
            }else{
                $response['message'] = "unable to delete data";
            }
            echo json_encode($response); die();
        }catch (Exception $e) {
            echo json_encode($response); die();
        }
    }
}