<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'Admin';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;


$route['v1-login'] = 'Admin/login';
$route['v1-change-password'] = 'Admin/changePassword';
$route['v1-get-terms-condition'] = 'Admin/getTermsCondition';
$route['v1-update-terms-condition'] = 'Admin/updateTermsCondition';
$route['v1-get-how-to-use'] = 'Admin/getHowToUse';
$route['v1-update-how-to-use'] = 'Admin/updateHowToUse';
$route['v1-get-mens-wisdom'] = 'Admin/getMensWisdom';
$route['v1-update-mens-wisdom'] = 'Admin/updateMensWisdom';
$route['v1-insert-mens-wisdom'] = 'Admin/insertMensWisdom';
$route['v1-get-daily-life'] = 'Admin/getDailyLife';
$route['v1-update-daily-life'] = 'Admin/updateDailyLife';
$route['v1-get-intimate-life'] = 'Admin/getIntimateLife';
$route['v1-update-intimate-life'] = 'Admin/updateIntimateLife';


//Mobile-Api
$route['v1-user-login'] = 'Mobile/login';
$route['v1-add-profile'] = 'Mobile/addUser';
$route['v1-edit-profile'] = 'Mobile/editProfile';
$route['v1-delete-profile'] = 'Mobile/deleteProfile';

$route['v1-all-profile'] = 'Mobile/getAllProfile';
$route['v1-profile-data'] = 'Mobile/getProfileData';

$route['v1-add-observation'] = 'Mobile/addObservation';
$route['v1-get-observation'] = 'Mobile/getObservation';
$route['v1-edit-observation'] = 'Mobile/editObservation';
$route['v1-delete-observation'] = 'Mobile/deleteObservation';

$route['v1-add-event'] = 'Mobile/addEvent';
$route['v1-get-event'] = 'Mobile/getEvent';
$route['v1-edit-event'] = 'Mobile/editEvent';
$route['v1-delete-event'] = 'Mobile/deleteEvent';


//Streaming


$route['v2-create-room'] = 'Streaming/createRoom';
$route['v2-room-log'] = 'Streaming/roomLog';
$route['v2-get-room-log'] = 'Streaming/getRoomLog';

$route['v2-generate-room-id'] = 'Streaming/createRoomId';
$route['v2-update-room-host'] = 'Streaming/updateRoomDetail';
$route['v2-join-room'] = 'Streaming/joinRoom';
$route['v2-left-room'] = 'Streaming/leftRoom';
$route['v2-get-room-details'] = 'Streaming/roomDetails';
$route['v2-get-chats'] = 'Streaming/getChats';
$route['v2-sent-message'] = 'Streaming/sentMessage';
$route['v2-poll-question'] = 'Streaming/getQuestions';
$route['v2-poll-activate'] = 'Streaming/activatePoll';
$route['v2-get-activate-poll'] = 'Streaming/getActivatePollQuestion';
$route['v2-poll-answer'] = 'Streaming/storePollAnswer';
$route['v2-stream-recording'] = 'Streaming/getStreamRecording';




